`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 04/02/2018 11:04:02 PM
// Design Name: 
// Module Name: nl5_test
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////

module nl5_demo( );

`include "nl5_sv.svh"

string info;
int ret;
int ncir = -1;
int nout = -1;
int nin_C = -1;
int nin_R = -1;
int cur_time;
real x;

// Signal from analog circuit
reg out = 0;

// 3 inverters
wire Y1 = ~out;
wire Y2 = ~Y1;
wire Y3 = ~Y2;

initial begin

	ret = NL5_OpenDLL("nl5_dll.dll");

	info = NL5_GetInfo();
	$display(info);

	ncir = NL5_Open("rc.nl5");
	nout = NL5_GetOutput(ncir, "out");
	nin_C = NL5_GetInput(ncir, "in_C");
	nin_R = NL5_GetInput(ncir, "in_R");
		
	forever begin
		#1ns

		x = (Y2 == 1) ? 5.0 : 0.0;
		ret = NL5_SetInputValue(ncir, nin_C, x); 
		x = (Y3 == 1) ? 5.0 : 0.0;
		ret = NL5_SetInputValue(ncir, nin_R, x); 

		ret = NL5_Simulate(ncir, 1.0e-9);
		
		ret = NL5_GetOutputValue(ncir, nout, x); 
		out = (x > 2.5) ? 1 : 0;
		
		cur_time = $time;
		if(cur_time >= 999) begin
			ret = NL5_SaveAs(ncir, "result.nl5");    
			$finish;
		end    
	end   	

end

endmodule
