clear;
clc;
close all;
R=logspace(-1,1,50);

% load library
loadlibrary('nl5_dll.dll', 'nl5_dll.h');

% open schematic
is = calllib('nl5_dll', 'NL5_Open', 'dll_example.nl5');
calllib('nl5_dll', 'NL5_GetError');

% get trace handle
it = calllib('nl5_dll', 'NL5_GetTrace', is, 'V(out)');

% create pointers to data
pd = libpointer('doublePtr', 0.0);

for k=1:50

    % set R1 value
	calllib('nl5_dll', 'NL5_SetValue', is, 'R1', R(k));
	
    % simulate for 10 s
    calllib('nl5_dll', 'NL5_Start', is);
    calllib('nl5_dll', 'NL5_Simulate', is, 10.0);
	
    % read data
	for i=1:100
		t = i*0.1;
		calllib('nl5_dll', 'NL5_GetData', is, it, t, pd);	
		Z(k,i)=pd.value;
	end

end

% close document
calllib('nl5_dll', 'NL5_Close', is);
calllib('nl5_dll', 'NL5_GetError');

% unload library
unloadlibrary 'nl5_dll';

[X,Y] = meshgrid(1:100,1:50);
surf(X,Y,Z);
shading flat;
colormap jet;
colorbar;
ylim([0 50]);
